//GEMINI-pro DATASET v1.0 Category: Password management ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PASSWORDS 100
#define MAX_PASSWORD_LEN 32

typedef struct {
    char username[MAX_PASSWORD_LEN];
    char password[MAX_PASSWORD_LEN];
    int expires_in; // days
} password_entry;

// Global array of password entries
password_entry passwords[MAX_PASSWORDS];

// Number of password entries
int num_passwords = 0;

// Function to add a new password entry
void add_password(char *username, char *password, int expires_in) {
    if (num_passwords >= MAX_PASSWORDS) {
        printf("Error: Maximum number of passwords reached\n");
        return;
    }

    strcpy(passwords[num_passwords].username, username);
    strcpy(passwords[num_passwords].password, password);
    passwords[num_passwords].expires_in = expires_in;

    num_passwords++;
}

// Function to delete a password entry
void delete_password(char *username) {
    int i;

    for (i = 0; i < num_passwords; i++) {
        if (strcmp(passwords[i].username, username) == 0) {
            break;
        }
    }

    if (i == num_passwords) {
        printf("Error: Password not found\n");
        return;
    }

    // Shift all entries after the deleted entry down one
    for (; i < num_passwords - 1; i++) {
        passwords[i] = passwords[i + 1];
    }

    num_passwords--;
}

// Function to search for a password entry
password_entry *search_password(char *username) {
    int i;

    for (i = 0; i < num_passwords; i++) {
        if (strcmp(passwords[i].username, username) == 0) {
            return &passwords[i];
        }
    }

    return NULL;
}

// Function to print all password entries
void print_passwords() {
    int i;

    for (i = 0; i < num_passwords; i++) {
        printf("%s: %s (expires in %d days)\n", passwords[i].username, passwords[i].password, passwords[i].expires_in);
    }
}

// Main function
int main() {
    // Add some sample passwords
    add_password("admin", "password1", 30);
    add_password("user1", "password2", 14);
    add_password("user2", "password3", 7);

    // Print all passwords
    print_passwords();

    // Delete a password
    delete_password("user1");

    // Search for a password
    password_entry *password = search_password("admin");
    if (password != NULL) {
        printf("Found password for %s: %s\n", password->username, password->password);
    } else {
        printf("Password not found\n");
    }

    return 0;
}