//Gemma-7B DATASET v1.0 Category: GPS Navigation Simulation ; Style: all-encompassing
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#define PI 3.14159

// Define the GPS satellite constellation
#define NUM_SATELLITES 3
double sat_coords[NUM_SATELLITES][3] = {
    {1.224, -1.534, 10.101},
    {3.542, 2.614, 11.202},
    {5.860, -4.728, 12.303}
};

// Define the GPS receiver position
double rx_pos[3] = {0.0, 0.0, 0.0};

// Calculate the distance to a satellite
double calculate_distance(double x, double y, double z) {
    return sqrt(x * x + y * y + z * z);
}

// Calculate the time delay for a satellite
double calculate_time_delay(double distance) {
    return (distance / 299792458) * 1000;
}

// Simulate GPS signal reception
void simulate_gps_reception() {
    // Calculate the distances to each satellite
    double distances[NUM_SATELLITES];
    for (int i = 0; i < NUM_SATELLITES; i++) {
        distances[i] = calculate_distance(sat_coords[i][0] - rx_pos[0], sat_coords[i][1] - rx_pos[1], sat_coords[i][2] - rx_pos[2]);
    }

    // Calculate the time delays for each satellite
    double time_delays[NUM_SATELLITES];
    for (int i = 0; i < NUM_SATELLITES; i++) {
        time_delays[i] = calculate_time_delay(distances[i]);
    }

    // Display the results
    printf("Satellite distances:");
    for (int i = 0; i < NUM_SATELLITES; i++) {
        printf(", %.2f km", distances[i]);
    }

    printf("\nSatellite time delays:");
    for (int i = 0; i < NUM_SATELLITES; i++) {
        printf(", %.2f ms", time_delays[i]);
    }
}

int main() {
    simulate_gps_reception();

    return 0;
}