//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: scalable
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define LENGTH 8
#define UPPER 1
#define LOWER 2
#define NUMBER 4
#define SPECIAL 8

int check_password_strength(char *password);

int main() {
    char password[LENGTH + 1];
    int strength;

    printf("Enter your password: ");
    fgets(password, LENGTH + 1, stdin);

    strength = check_password_strength(password);

    switch (strength) {
        case 0:
            printf("Weak password\n");
            break;
        case 1:
            printf("Fair password\n");
            break;
        case 2:
            printf("Good password\n");
            break;
        case 3:
            printf("Strong password\n");
            break;
        default:
            printf("Invalid password\n");
            break;
    }

    return 0;
}

int check_password_strength(char *password) {
    int length = strlen(password);
    int has_uppercase = 0;
    int has_lowercase = 0;
    int has_number = 0;
    int has_special = 0;

    if (length < LENGTH) {
        return 0;
    }

    for (int i = 0; i < length; i++) {
        if (isupper(password[i])) {
            has_uppercase = 1;
        } else if (islower(password[i])) {
            has_lowercase = 1;
        } else if (isdigit(password[i])) {
            has_number = 1;
        } else if (ispunct(password[i])) {
            has_special = 1;
        }
    }

    int strength = 0;

    if (has_uppercase) {
        strength |= UPPER;
    }

    if (has_lowercase) {
        strength |= LOWER;
    }

    if (has_number) {
        strength |= NUMBER;
    }

    if (has_special) {
        strength |= SPECIAL;
    }

    return strength;
}