//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NODES 1000
#define MAX_EDGES 10000

typedef struct {
    char name[20];
    int id;
    int degree;
} Node;

typedef struct {
    int u;
    int v;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];
int num_nodes = 0;
int num_edges = 0;

void add_node(char* name) {
    if (num_nodes == MAX_NODES) {
        printf("Error: Maximum number of nodes exceeded.\n");
        return;
    }
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = num_nodes;
    nodes[num_nodes].degree = 0;
    num_nodes++;
}

void add_edge(int u, int v) {
    if (num_edges == MAX_EDGES) {
        printf("Error: Maximum number of edges exceeded.\n");
        return;
    }
    edges[num_edges].u = u;
    edges[num_edges].v = v;
    num_edges++;
    nodes[u].degree++;
    nodes[v].degree++;
}

void print_nodes() {
    printf("Nodes:\n");
    for (int i = 0; i < num_nodes; i++) {
        printf("%d. %s (%d)\n", i, nodes[i].name, nodes[i].degree);
    }
}

void print_edges() {
    printf("Edges:\n");
    for (int i = 0; i < num_edges; i++) {
        printf("%d -> %d\n", edges[i].u, edges[i].v);
    }
}

int main() {
    add_node("Node 1");
    add_node("Node 2");
    add_node("Node 3");
    add_node("Node 4");
    add_edge(0, 1);
    add_edge(1, 2);
    add_edge(2, 3);
    add_edge(3, 0);
    print_nodes();
    print_edges();
    return 0;
}