//GEMINI-pro DATASET v1.0 Category: Procedural Space Adventure ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PLANETS 100
#define MAX_SHIPS 10
#define MAX_WEAPONS 10

typedef struct {
    char name[20];
    int size;
    int population;
    int resources;
} planet;

typedef struct {
    char name[20];
    int size;
    int speed;
    int weapons[MAX_WEAPONS];
} ship;

typedef struct {
    char name[20];
    int damage;
    int range;
} weapon;

planet planets[MAX_PLANETS];
ship ships[MAX_SHIPS];
weapon weapons[MAX_WEAPONS];

void generate_universe() {
    int i, j;

    // Seed the random number generator.
    srand(time(NULL));

    // Generate the planets.
    for (i = 0; i < MAX_PLANETS; i++) {
        sprintf(planets[i].name, "Planet %d", i);
        planets[i].size = rand() % 1000;
        planets[i].population = rand() % 1000000;
        planets[i].resources = rand() % 10000;
    }

    // Generate the ships.
    for (i = 0; i < MAX_SHIPS; i++) {
        sprintf(ships[i].name, "Ship %d", i);
        ships[i].size = rand() % 1000;
        ships[i].speed = rand() % 100;
        for (j = 0; j < MAX_WEAPONS; j++) {
            ships[i].weapons[j] = rand() % MAX_WEAPONS;
        }
    }

    // Generate the weapons.
    for (i = 0; i < MAX_WEAPONS; i++) {
        sprintf(weapons[i].name, "Weapon %d", i);
        weapons[i].damage = rand() % 100;
        weapons[i].range = rand() % 100;
    }
}

void print_universe() {
    int i, j;

    // Print the planets.
    printf("Planets:\n");
    for (i = 0; i < MAX_PLANETS; i++) {
        printf("  %s (size: %d, population: %d, resources: %d)\n", planets[i].name, planets[i].size, planets[i].population, planets[i].resources);
    }

    // Print the ships.
    printf("\nShips:\n");
    for (i = 0; i < MAX_SHIPS; i++) {
        printf("  %s (size: %d, speed: %d, weapons: ", ships[i].name, ships[i].size, ships[i].speed);
        for (j = 0; j < MAX_WEAPONS; j++) {
            printf("%s ", weapons[ships[i].weapons[j]].name);
        }
        printf(")\n");
    }

    // Print the weapons.
    printf("\nWeapons:\n");
    for (i = 0; i < MAX_WEAPONS; i++) {
        printf("  %s (damage: %d, range: %d)\n", weapons[i].name, weapons[i].damage, weapons[i].range);
    }
}

int main() {
    // Generate the universe.
    generate_universe();

    // Print the universe.
    print_universe();

    return 0;
}