//Code Llama-13B DATASET v1.0 Category: File handling ; Style: authentic
/*
 * File Handling Program
 *
 * This program demonstrates how to perform various file handling operations
 * in C.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

// Function to create a file
void createFile(char *filepath, char *filename) {
  // Open the file in write mode
  FILE *file = fopen(filepath, "w");
  if (file == NULL) {
    printf("Error opening file for writing\n");
    exit(1);
  }

  // Write some data to the file
  char data[] = "Hello, World!";
  fwrite(data, sizeof(char), strlen(data), file);

  // Close the file
  fclose(file);
}

// Function to read a file
void readFile(char *filepath) {
  // Open the file in read mode
  FILE *file = fopen(filepath, "r");
  if (file == NULL) {
    printf("Error opening file for reading\n");
    exit(1);
  }

  // Read the data from the file
  char data[256];
  fread(data, sizeof(char), 256, file);

  // Print the data
  printf("%s\n", data);

  // Close the file
  fclose(file);
}

// Function to delete a file
void deleteFile(char *filepath) {
  // Remove the file
  remove(filepath);
}

// Main function
int main() {
  // Create a file
  createFile("file.txt", "hello.txt");

  // Read the file
  readFile("file.txt");

  // Delete the file
  deleteFile("file.txt");

  return 0;
}