//Falcon2-11B DATASET v1.0 Category: Task Scheduler ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <semaphore.h>

#define MAX_TASKS 5
#define TASK_LIMIT 100

pthread_mutex_t tasks_lock = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t task_available = PTHREAD_COND_INITIALIZER;
sem_t task_sem;

void* task_func(void* args) {
    int task_id = *(int*)args;
    printf("Task %d starting...\n", task_id);
    // Do some work here...
    printf("Task %d done!\n", task_id);
    return NULL;
}

int main() {
    int task_id;

    sem_init(&task_sem, 0, 0);
    pthread_mutex_lock(&tasks_lock);
    task_id = 1; // Assign first task ID

    for(int i = 1; i <= MAX_TASKS; i++) {
        int num_tasks = rand() % TASK_LIMIT + 1;
        pthread_t thread;

        pthread_mutex_lock(&tasks_lock);
        task_id++; // Assign next task ID
        pthread_create(&thread, NULL, task_func, (void*)&task_id);
        pthread_cond_wait(&task_available, &tasks_lock);
        pthread_mutex_unlock(&tasks_lock);

        for(int j = 0; j < num_tasks; j++) {
            pthread_mutex_lock(&tasks_lock);
            sem_post(&task_sem);
            pthread_cond_wait(&task_available, &tasks_lock);
            pthread_mutex_unlock(&tasks_lock);
        }

        pthread_join(thread, NULL);
        printf("Task %d done!\n", task_id);
    }
    pthread_mutex_unlock(&tasks_lock);

    return 0;
}