//LLAMA2-13B DATASET v1.0 Category: Email Client ; Style: portable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 25

struct email {
    char *from;
    char *to;
    char *subject;
    char *body;
};

int main(int argc, char *argv[]) {
    int sock;
    struct email email;

    if (argc != 4) {
        printf("Usage: %s <from> <to> <subject> <body>\n", argv[0]);
        return 1;
    }

    email.from = argv[1];
    email.to = argv[2];
    email.subject = argv[3];
    email.body = argv[4];

    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket");
        return 1;
    }

    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr);

    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect");
        return 1;
    }

    char *message = "Hello, this is a test email sent from the command line!";
    send(sock, message, strlen(message), 0);

    recv(sock, (char *)&email, sizeof(email), 0);

    printf("Received email from %s to %s with subject %s and body %s\n",
           email.from, email.to, email.subject, email.body);

    close(sock);

    return 0;
}