//MISTRAL-7B DATASET v1.0 Category: Compression algorithms ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUF_SIZE 1024

void compress(const char *input, char *output) {
    char buf[BUF_SIZE];
    int len = 0;
    int count = 1;

    while (*input) {
        buf[len++] = *input++;
        if (*input) {
            if (len > BUF_SIZE - 1) {
                output[++len] = count;
                len++;
                count = 1;
                memset(buf, 0, BUF_SIZE);
            }
            if (*input == buf[len - 1]) {
                count++;
            } else {
                output[++len] = buf[len - 1];
                output[++len] = count;
                count = 1;
                memset(buf, 0, BUF_SIZE);
            }
        }
    }

    if (len > BUF_SIZE - 1) {
        output[++len] = count;
        len++;
    }

    output[len] = '\0';
}

int main() {
    char input[100] = "aaabbbbbcccca";
    char output[512] = { 0 };
    int size = strlen(input);

    compress(input, output);

    printf("Compressed size: %d\n", (int)(strlen(output) / 2));
    printf("Compressed data: %s\n", output);

    return 0;
}