//LLAMA2-13B DATASET v1.0 Category: Unit converter ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the unit conversion constants
const double PI = 3.14159;
const double INV_PI = 1 / PI;
const double RAD_PER_DEG = 180 / PI;
const double DEG_PER_RAD = PI / 180;

// Define the conversion factors
const double METER_PER_FOOT = 0.3048;
const double FOOT_PER_METER = 0.3280;
const double METER_PER_YARD = 1.0936;
const double YARD_PER_METER = 0.9144;
const double KILOMETER_PER_MILE = 0.621371;
const double MILE_PER_KILOMETER = 1.609344;
const double SECOND_PER_MINUTE = 60;
const double MINUTE_PER_SECOND = 1 / 60;
const double HOUR_PER_MINUTE = 60;
const double MINUTE_PER_HOUR = 1 / 60;

// Define the unit conversion functions
double meter_to_foot(double meters) {
    return meters * METER_PER_FOOT;
}

double foot_to_meter(double feet) {
    return feet / METER_PER_FOOT;
}

double meter_to_yard(double meters) {
    return meters * METER_PER_YARD;
}

double yard_to_meter(double yards) {
    return yards / METER_PER_YARD;
}

double kilometer_to_mile(double kilometers) {
    return kilometers * KILOMETER_PER_MILE;
}

double mile_to_kilometer(double miles) {
    return miles / KILOMETER_PER_MILE;
}

double second_to_minute(double seconds) {
    return seconds * SECOND_PER_MINUTE;
}

double minute_to_second(double minutes) {
    return minutes / SECOND_PER_MINUTE;
}

double hour_to_minute(double hours) {
    return hours * HOUR_PER_MINUTE;
}

double minute_to_hour(double minutes) {
    return minutes / HOUR_PER_MINUTE;
}

int main() {
    // Convertion examples
    double meters = 5;
    double feet = meter_to_foot(meters);
    double yards = meter_to_yard(meters);
    double kilometers = 10;
    double miles = kilometer_to_mile(kilometers);
    double seconds = 30;
    double minutes = second_to_minute(seconds);
    double hours = minute_to_hour(minutes);

    // Print the conversion results
    printf("5 meters = %f feet\n", feet);
    printf("5 meters = %f yards\n", yards);
    printf("10 kilometers = %f miles\n", miles);
    printf("30 seconds = %f minutes\n", minutes);
    printf("30 seconds = %f hours\n", hours);

    return 0;
}