//GPT-4o-mini DATASET v1.0 Category: Random Conspiracy Theory Generator ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_THEORIES 100
#define MAX_STR_LEN 256

// Structure to hold a conspiracy theory
typedef struct {
    char title[MAX_STR_LEN];
    char description[MAX_STR_LEN];
} ConspiracyTheory;

// Function to generate a random integer in a given range
int random_range(int min, int max) {
    return rand() % (max - min + 1) + min;
}

// Function to pick a random element from an array of strings
const char* pick_random_element(const char* arr[], int size) {
    return arr[random_range(0, size - 1)];
}

// Function to generate a random conspiracy theory
void generate_conspiracy_theory(ConspiracyTheory* theory) {
    const char* subjects[] = {
        "aliens", "government", "media", "financial institutions",
        "technology", "celebrities", "big pharma", "weather modification",
        "ancient civilizations", "secret societies"
    };

    const char* verbs[] = {
        "control", "manipulate", "observe", "hide", 
        "exploit", "monitor", "infiltrate", "create", 
        "suppress", "engineer"
    };

    const char* agents[] = {
        "the Illuminati", "the Freemasons", "NASA", "the CIA", 
        "Hollywood", "the UN", "the Rothschilds", "Bill Gates", 
        "the elite", "the WEF"
    };

    const char* effects[] = {
        "to distract the masses", "to gain more power", 
        "to control the narrative", "to establish a new world order", 
        "to suppress the truth", "to generate fear", 
        "to profit from chaos", "to maintain a monopoly", 
        "to indoctrinate the youth", "to create a distraction"
    };

    // Randomly select elements to create a theory
    snprintf(theory->title, MAX_STR_LEN, "The %s Conspiracy", pick_random_element(subjects, 10));
    snprintf(theory->description, MAX_STR_LEN, 
        "It is believed that %s %s %s %s.",
        pick_random_element(agents, 10),
        pick_random_element(verbs, 10),
        pick_random_element(subjects, 10),
        pick_random_element(effects, 10));
}

// Function to display the conspiracy theory
void display_conspiracy(const ConspiracyTheory* theory) {
    printf("=== Conspiracy Theory ===\n");
    printf("Title: %s\n", theory->title);
    printf("Description: %s\n", theory->description);
    printf("=========================\n\n");
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    ConspiracyTheory theories[MAX_THEORIES];
    int total_theories = 5; // Generate a fixed number of theories

    printf("Generating Random Conspiracy Theories:\n\n");

    for(int i = 0; i < total_theories; i++) {
        generate_conspiracy_theory(&theories[i]);
        display_conspiracy(&theories[i]);
    }

    return 0;
}