//Falcon-180B DATASET v1.0 Category: Password management ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PASSWORDS 100

typedef struct {
    char name[50];
    char password[50];
} Password;

void add_password(Password *passwords, int num_passwords, char *name, char *password) {
    if (num_passwords == MAX_PASSWORDS) {
        printf("Error: Maximum number of passwords reached.\n");
        return;
    }

    strcpy(passwords[num_passwords].name, name);
    strcpy(passwords[num_passwords].password, password);
    num_passwords++;
}

void delete_password(Password *passwords, int num_passwords, char *name) {
    int i;

    for (i = 0; i < num_passwords; i++) {
        if (strcmp(passwords[i].name, name) == 0) {
            num_passwords--;
            if (i < num_passwords) {
                strcpy(passwords[i].name, passwords[num_passwords].name);
                strcpy(passwords[i].password, passwords[num_passwords].password);
            }
            break;
        }
    }
}

void change_password(Password *passwords, int num_passwords, char *name, char *new_password) {
    int i;

    for (i = 0; i < num_passwords; i++) {
        if (strcmp(passwords[i].name, name) == 0) {
            strcpy(passwords[i].password, new_password);
            break;
        }
    }
}

void print_passwords(Password *passwords, int num_passwords) {
    int i;

    for (i = 0; i < num_passwords; i++) {
        printf("%s: %s\n", passwords[i].name, passwords[i].password);
    }
}

int main() {
    Password passwords[MAX_PASSWORDS];
    int num_passwords = 0;

    add_password(passwords, num_passwords, "example.com", "password123");
    add_password(passwords, num_passwords, "google.com", "mypassword");

    print_passwords(passwords, num_passwords);

    delete_password(passwords, num_passwords, "example.com");

    print_passwords(passwords, num_passwords);

    change_password(passwords, num_passwords, "google.com", "newpassword");

    print_passwords(passwords, num_passwords);

    return 0;
}