//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: artistic
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdbool.h>

#define MAX_PASSWORD_LENGTH 64

bool is_password_strong(char* password);

int main() {
    char password[MAX_PASSWORD_LENGTH];
    printf("Enter your password: ");
    fgets(password, MAX_PASSWORD_LENGTH, stdin);
    if (is_password_strong(password)) {
        printf("Your password is strong!\n");
    } else {
        printf("Your password is weak.\n");
    }
    return 0;
}

bool is_password_strong(char* password) {
    int length = strlen(password);
    if (length < 8) {
        return false;
    }
    if (!isalpha(password[0])) {
        return false;
    }
    if (!isdigit(password[length - 1])) {
        return false;
    }
    if (!isupper(password[length - 2])) {
        return false;
    }
    if (!islower(password[length - 3])) {
        return false;
    }
    if (!isalpha(password[length - 4])) {
        return false;
    }
    if (!isdigit(password[length - 5])) {
        return false;
    }
    if (!isupper(password[length - 6])) {
        return false;
    }
    if (!islower(password[length - 7])) {
        return false;
    }
    return true;
}