//Falcon-180B DATASET v1.0 Category: Digital Diary ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <math.h>

#define MAX_ENTRIES 100
#define MAX_ENTRY_LENGTH 500

typedef struct {
    time_t timestamp;
    char entry[MAX_ENTRY_LENGTH];
} Entry;

Entry entries[MAX_ENTRIES];
int num_entries = 0;

void add_entry(const char* text) {
    if (num_entries >= MAX_ENTRIES) {
        printf("Error: Maximum number of entries reached.\n");
        return;
    }

    time_t now = time(NULL);
    struct tm* tm = localtime(&now);
    char timestamp_str[20];
    strftime(timestamp_str, sizeof(timestamp_str), "%Y-%m-%d %H:%M:%S", tm);

    int length = strlen(text);
    if (length > MAX_ENTRY_LENGTH) {
        printf("Error: Entry is too long.\n");
        return;
    }

    strcpy(entries[num_entries].entry, text);
    entries[num_entries].timestamp = now;
    num_entries++;

    printf("Entry added:\n%s\n", text);
}

void view_entries() {
    if (num_entries == 0) {
        printf("No entries found.\n");
        return;
    }

    printf("Entries:\n");
    for (int i = 0; i < num_entries; i++) {
        struct tm* tm = localtime(&entries[i].timestamp);
        char timestamp_str[20];
        strftime(timestamp_str, sizeof(timestamp_str), "%Y-%m-%d %H:%M:%S", tm);

        printf("%s - %s\n", timestamp_str, entries[i].entry);
    }
}

void search_entries(const char* keyword) {
    if (num_entries == 0) {
        printf("No entries found.\n");
        return;
    }

    for (int i = 0; i < num_entries; i++) {
        if (strstr(entries[i].entry, keyword)) {
            printf("%s\n", entries[i].entry);
        }
    }
}

int main() {
    add_entry("Hello, world!");
    add_entry("This is my digital diary.");

    view_entries();
    search_entries("digital");

    return 0;
}