//GPT-4o-mini DATASET v1.0 Category: Password Strength Checker ; Style: systematic
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define MIN_LENGTH 8
#define MAX_LENGTH 20

int check_length(const char *password) {
    int length = strlen(password);
    return length >= MIN_LENGTH && length <= MAX_LENGTH;
}

int check_uppercase(const char *password) {
    while (*password) {
        if (isupper(*password)) {
            return 1; // Found an uppercase letter
        }
        password++;
    }
    return 0; // No uppercase letter found
}

int check_lowercase(const char *password) {
    while (*password) {
        if (islower(*password)) {
            return 1; // Found a lowercase letter
        }
        password++;
    }
    return 0; // No lowercase letter found
}

int check_digit(const char *password) {
    while (*password) {
        if (isdigit(*password)) {
            return 1; // Found a digit
        }
        password++;
    }
    return 0; // No digit found
}

int check_special_char(const char *password) {
    const char *special_chars = "!@#$%^&*()-_+=<>?";
    while (*password) {
        if (strchr(special_chars, *password)) {
            return 1; // Found a special character
        }
        password++;
    }
    return 0; // No special character found
}

void evaluate_password_strength(const char *password) {
    int length_valid = check_length(password);
    int uppercase_valid = check_uppercase(password);
    int lowercase_valid = check_lowercase(password);
    int digit_valid = check_digit(password);
    int special_valid = check_special_char(password);

    int valid_criteria = length_valid + uppercase_valid + lowercase_valid + digit_valid + special_valid;

    printf("Evaluating Password: \"%s\"\n", password);
    printf("Length Valid: %s\n", length_valid ? "Yes" : "No");
    printf("Uppercase Valid: %s\n", uppercase_valid ? "Yes" : "No");
    printf("Lowercase Valid: %s\n", lowercase_valid ? "Yes" : "No");
    printf("Digit Valid: %s\n", digit_valid ? "Yes" : "No");
    printf("Special Character Valid: %s\n", special_valid ? "Yes" : "No");

    if (valid_criteria == 5) {
        printf("Password Strength: Strong\n");
    } else if (valid_criteria >= 3) {
        printf("Password Strength: Medium\n");
    } else {
        printf("Password Strength: Weak\n");
    }
}

int main() {
    char password[MAX_LENGTH + 1];

    printf("Enter your password (8-20 characters): ");
    fgets(password, sizeof(password), stdin);

    // Remove newline character if present
    size_t len = strlen(password);
    if (len > 0 && password[len - 1] == '\n') {
        password[len - 1] = '\0';
    }

    evaluate_password_strength(password);

    return 0;
}