//Falcon-180B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_BAGS 100
#define NUM_DESTINATIONS 10
#define NUM_BAG_TYPES 5

typedef struct {
    int destination;
    int bag_type;
} Bag;

Bag bags[NUM_BAGS];
int num_bags;

void generate_bags() {
    srand(time(NULL));
    for (int i = 0; i < NUM_BAGS; i++) {
        bags[i].destination = rand() % NUM_DESTINATIONS;
        bags[i].bag_type = rand() % NUM_BAG_TYPES;
    }
    num_bags = NUM_BAGS;
}

void sort_bags(int (*compar)(const void *, const void *)) {
    qsort(bags, num_bags, sizeof(Bag), compar);
}

int compare_destination(const void *a, const void *b) {
    const Bag *bag1 = a;
    const Bag *bag2 = b;
    return bag1->destination - bag2->destination;
}

int compare_bag_type(const void *a, const void *b) {
    const Bag *bag1 = a;
    const Bag *bag2 = b;
    return bag1->bag_type - bag2->bag_type;
}

void print_bags() {
    printf("Bags:\n");
    for (int i = 0; i < num_bags; i++) {
        printf("%d -> %d, Bag Type: %d\n", bags[i].destination, i, bags[i].bag_type);
    }
}

int main() {
    generate_bags();
    print_bags();
    sort_bags(compare_destination);
    print_bags();
    sort_bags(compare_bag_type);
    return 0;
}