//MISTRAL-7B DATASET v1.0 Category: Rogue-like Game with Procedural Generation ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 21
#define HEIGHT 11

char dungeon[HEIGHT][WIDTH];

void generate_dungeon() {
    int x, y;
    for (y = 0; y < HEIGHT; y++) {
        for (x = 0; x < WIDTH; x++) {
            dungeon[y][x] = '.' ;
        }
    }

    srand(time(NULL));

    dungeon[5][5] = 'S'; // Starting Point
    dungeon[rand() % HEIGHT][rand() % WIDTH] = 'E'; // Random Enemy

    for (y = 0; y < HEIGHT; y++) {
        for (x = 0; x < WIDTH; x++) {
            if (dungeon[y][x] == '.') {
                int chance = rand() % 10;
                if (chance < 5) {
                    dungeon[y][x] = 'W'; // Wall
                } else if (y > 0 && dungeon[y-1][x] != 'W') {
                    dungeon[y][x] = ' '; // Floor
                    dungeon[y-1][x] = 'W';
                } else if (x > 0 && dungeon[y][x-1] != 'W') {
                    dungeon[y][x] = ' ';
                    dungeon[y][x-1] = 'W';
                }
            }
        }
    }
}

void print_dungeon() {
    int y, x;
    for (y = 0; y < HEIGHT; y++) {
        for (x = 0; x < WIDTH; x++) {
            printf("%c", dungeon[y][x]);
        }
        printf("\n");
    }
}

int main() {
    generate_dungeon();
    print_dungeon();
    return 0;
}