//MISTRAL-7B DATASET v1.0 Category: Interprocess communication ; Style: configurable
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#define PIPE_SIZE 1024

void parent() {
    pid_t child_pid;
    int fd[2];
    char message[PIPE_SIZE];

    if (pipe(fd) < 0) {
        perror("pipe failed");
        exit(EXIT_FAILURE);
    }

    child_pid = fork();

    if (child_pid < 0) {
        perror("fork failed");
        exit(EXIT_FAILURE);
    } else if (child_pid > 0) {
        close(fd[0]); // Close reading end in parent process

        printf("Parent: Sending message to child: %s\n", "Hello World!");
        write(fd[1], "Hello World!", strlen("Hello World!"));
        close(fd[1]);

        wait(NULL); // Wait for child to terminate
    } else {
        close(fd[1]); // Close writing end in child process

        read(fd[0], message, PIPE_SIZE);
        printf("Child: Received message from parent: %s\n", message);
        close(fd[0]);

        exit(EXIT_SUCCESS);
    }
}

void child() {
    parent();
}

int main() {
    parent();

    return 0;
}