//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: invasive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of candidates and voters
#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

// Define the structure of a candidate
typedef struct {
  char name[50];
  int votes;
} Candidate;

// Define the structure of a voter
typedef struct {
  char name[50];
  int voted;
} Voter;

// Define the global variables
Candidate candidates[MAX_CANDIDATES];
Voter voters[MAX_VOTERS];
int num_candidates = 0;
int num_voters = 0;

// Function to add a candidate
void add_candidate(char *name) {
  if (num_candidates < MAX_CANDIDATES) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
  } else {
    printf("Error: Maximum number of candidates reached.\n");
  }
}

// Function to add a voter
void add_voter(char *name) {
  if (num_voters < MAX_VOTERS) {
    strcpy(voters[num_voters].name, name);
    voters[num_voters].voted = 0;
    num_voters++;
  } else {
    printf("Error: Maximum number of voters reached.\n");
  }
}

// Function to vote for a candidate
void vote(char *candidate_name, char *voter_name) {
  int i, j;

  // Find the candidate
  for (i = 0; i < num_candidates; i++) {
    if (strcmp(candidates[i].name, candidate_name) == 0) {
      break;
    }
  }

  // Find the voter
  for (j = 0; j < num_voters; j++) {
    if (strcmp(voters[j].name, voter_name) == 0) {
      break;
    }
  }

  // Check if the voter has already voted
  if (voters[j].voted == 1) {
    printf("Error: Voter has already voted.\n");
  } else {
    // Increment the candidate's vote count
    candidates[i].votes++;

    // Mark the voter as having voted
    voters[j].voted = 1;
  }
}

// Function to print the results of the election
void print_results() {
  int i;

  // Print the header
  printf("Election Results:\n");

  // Print the candidates and their vote counts
  for (i = 0; i < num_candidates; i++) {
    printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
  }

  // Find the winner
  int max_votes = 0;
  char winner[50];
  for (i = 0; i < num_candidates; i++) {
    if (candidates[i].votes > max_votes) {
      max_votes = candidates[i].votes;
      strcpy(winner, candidates[i].name);
    }
  }

  // Print the winner
  printf("Winner: %s\n", winner);
}

// Main function
int main() {
  // Add some candidates
  add_candidate("Alice");
  add_candidate("Bob");
  add_candidate("Carol");

  // Add some voters
  add_voter("John");
  add_voter("Mary");
  add_voter("Tom");

  // Vote for some candidates
  vote("Alice", "John");
  vote("Bob", "Mary");
  vote("Carol", "Tom");

  // Print the results of the election
  print_results();

  return 0;
}