//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <string.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <netdb.h>

#define MAX_PKT_SIZE 65535
#define TRUE 1
#define FALSE 0

struct packet {
    u_char *data;
    int size;
};

pcap_t *handle;
char errbuf[PCAP_ERRBUF_SIZE];
char *dev;
int snapshot_length = MAX_PKT_SIZE;
int linktype;
int timeout = 500;
int flag = 0;

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct packet *pkt = (struct packet *) args;
    pkt->data = (u_char *) malloc(header->len);
    pkt->size = header->len;
    memcpy(pkt->data, packet, header->len);
}

int main(int argc, char *argv[]) {
    if (argc < 2) {
        printf("Usage: %s <interface>\n", argv[0]);
        exit(1);
    }

    dev = argv[1];
    handle = pcap_open_live(dev, snapshot_length, 1, 1000, errbuf);

    if (handle == NULL) {
        printf("Error: %s\n", errbuf);
        exit(1);
    }

    linktype = pcap_datalink(handle);

    if (linktype!= DLT_EN10MB) {
        printf("Error: unsupported datalink type\n");
        exit(1);
    }

    pcap_loop(handle, -1, process_packet, NULL);
    pcap_close(handle);

    return 0;
}