//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>

#define SIZE 8

void print_binary(int n) {
    int i;
    for (i = 7; i >= 0; i--) {
        printf("%d", n & (1 << i));
    }
}

int main() {
    int arr1[SIZE] = {0b10101010, 0b01010101, 0b11110000, 0b00001111, 0b11001011, 0b00110101, 0b01111000, 0b10000110};
    int arr2[SIZE] = {0b10110101, 0b01001110, 0b11111111, 0b00000001, 0b10101010, 0b11000011, 0b00110001, 0b01111001};
    int result[SIZE];

    int i, j, k;

    // Bitwise AND operation
    for (i = 0; i < SIZE; i++) {
        result[i] = arr1[i] & arr2[i];
        printf("Result of bitwise AND operation: ");
        print_binary(result[i]);
        printf("\n");
    }

    // Bitwise OR operation
    for (i = 0; i < SIZE; i++) {
        result[i] = arr1[i] | arr2[i];
        printf("Result of bitwise OR operation: ");
        print_binary(result[i]);
        printf("\n");
    }

    // Bitwise XOR operation
    for (i = 0; i < SIZE; i++) {
        result[i] = arr1[i] ^ arr2[i];
        printf("Result of bitwise XOR operation: ");
        print_binary(result[i]);
        printf("\n");
    }

    // Bitwise NOT operation
    for (i = 0; i < SIZE; i++) {
        result[i] = ~arr1[i];
        printf("Result of bitwise NOT operation: ");
        print_binary(result[i]);
        printf("\n");
    }

    // Bitwise left shift operation
    for (i = 0; i < SIZE; i++) {
        result[i] = arr1[i] << 2;
        printf("Result of bitwise left shift operation: ");
        print_binary(result[i]);
        printf("\n");
    }

    // Bitwise right shift operation
    for (i = 0; i < SIZE; i++) {
        result[i] = arr1[i] >> 2;
        printf("Result of bitwise right shift operation: ");
        print_binary(result[i]);
        printf("\n");
    }

    return 0;
}