//GEMINI-pro DATASET v1.0 Category: Smart home automation ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdbool.h>

#define MAX_DEVICES 10

typedef struct {
    char name[32];
    char type[16];
    bool state;
} device_t;

device_t devices[MAX_DEVICES];
int num_devices = 0;

void add_device(char *name, char *type, bool state) {
    if (num_devices < MAX_DEVICES) {
        strcpy(devices[num_devices].name, name);
        strcpy(devices[num_devices].type, type);
        devices[num_devices].state = state;
        num_devices++;
    }
}

void print_devices() {
    for (int i = 0; i < num_devices; i++) {
        printf("%s (%s): %s\n", devices[i].name, devices[i].type, devices[i].state ? "ON" : "OFF");
    }
}

void toggle_device(char *name) {
    for (int i = 0; i < num_devices; i++) {
        if (strcmp(devices[i].name, name) == 0) {
            devices[i].state = !devices[i].state;
            return;
        }
    }
}

int main() {
    add_device("Lamp 1", "light", false);
    add_device("Fan 1", "fan", false);
    add_device("Thermostat 1", "thermostat", false);
    add_device("Door Lock 1", "lock", false);
    add_device("Camera 1", "camera", false);

    print_devices();

    toggle_device("Lamp 1");
    toggle_device("Fan 1");

    print_devices();

    return 0;
}