//LLAMA2-13B DATASET v1.0 Category: Socket programming ; Style: introspective
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#define PORT 8080

int main(int argc, char *argv[]) {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    struct sockaddr_in server_addr = {
        .sin_family = AF_INET,
        .sin_port = htons(PORT),
        .sin_addr.s_addr = INADDR_ANY
    };

    if (bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("bind failed");
        exit(1);
    }

    if (listen(sock, 3) < 0) {
        perror("listen failed");
        exit(1);
    }

    printf("Listening on port %d...\n", PORT);

    int client_sock = accept(sock, NULL, NULL);
    if (client_sock < 0) {
        perror("accept failed");
        exit(1);
    }

    char buffer[1024];
    int bytes_read = read(client_sock, buffer, 1024);
    if (bytes_read < 0) {
        perror("read failed");
        exit(1);
    }

    printf("Client message: %s\n", buffer);

    char *message = "Hello, client!";
    send(client_sock, message, strlen(message), 0);

    close(client_sock);

    return 0;
}