//GEMINI-pro DATASET v1.0 Category: Math exercise ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the maximum number of iterations for the Babylonian method
#define MAX_ITERATIONS 100

// Function to calculate the square root of a number using the Babylonian method
double babylonian_sqrt(double number) {
  // Check if the number is negative
  if (number < 0) {
    fprintf(stderr, "Error: Cannot calculate the square root of a negative number.\n");
    return NAN;
  }

  // Initialize the initial guess
  double guess = number / 2;

  // Iterate until the guess is sufficiently accurate
  for (int i = 0; i < MAX_ITERATIONS; i++) {
    // Calculate the next guess
    double next_guess = (guess + number / guess) / 2;

    // Check if the guess has converged
    if (fabs(next_guess - guess) < 0.000001) {
      return next_guess;
    }

    // Update the guess
    guess = next_guess;
  }

  // The guess did not converge within the maximum number of iterations
  fprintf(stderr, "Warning: The Babylonian method did not converge within the maximum number of iterations.\n");
  return guess;
}

// Function to test the Babylonian method
void test_babylonian_sqrt() {
  // Test the Babylonian method for various numbers
  double numbers[] = {1, 4, 9, 16, 25, 100, 1000, 10000};

  for (int i = 0; i < sizeof(numbers) / sizeof(double); i++) {
    double number = numbers[i];
    double sqrt_result = babylonian_sqrt(number);

    // Calculate the expected square root using the built-in sqrt() function
    double expected_sqrt = sqrt(number);

    // Print the results
    printf("Number: %.2f\n", number);
    printf("Babylonian square root: %.15f\n", sqrt_result);
    printf("Expected square root: %.15f\n", expected_sqrt);
    printf("Error: %.15f\n\n", fabs(sqrt_result - expected_sqrt));
  }
}

int main() {
  // Test the Babylonian method
  test_babylonian_sqrt();

  return 0;
}