//LLAMA2-13B DATASET v1.0 Category: Unit converter ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_UNITS 10

struct unit {
    const char *name;
    double factor;
};

struct unit units[] = {
    {"inch", 2.54},
    {"foot", 12 * 2.54},
    {"yard", 3 * 2.54},
    {"mile", 1760 * 2.54},
    {"pound", 0.453592},
    {"ounce", 0.0625},
    {"gram", 0.001},
    {"kilogram", 1000 * 0.001},
    {"meter", 0.3048},
    {"centimeter", 0.01 * 0.3048},
    {"millimeter", 0.001 * 0.01 * 0.3048}
};

void init_units(void) {
    int i;
    for (i = 0; i < MAX_UNITS; i++) {
        units[i].factor = 1;
    }
}

double convert(double value, int from_unit, int to_unit) {
    double factor = units[from_unit].factor;
    double result = value * factor;
    if (to_unit == from_unit) {
        return result;
    }
    for (int i = from_unit + 1; i < to_unit; i++) {
        factor /= units[i].factor;
        result *= factor;
    }
    return result;
}

int main(void) {
    init_units();
    double value = 5.5;
    int from_unit = 3; // foot
    int to_unit = 2;  // meter
    double result = convert(value, from_unit, to_unit);
    printf("Value in meter: %f\n", result);
    return 0;
}