//Code Llama-13B DATASET v1.0 Category: Bingo Simulator ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define NUM_CARDS 3
#define NUM_BINGO_TILES 5
#define NUM_TILES_PER_ROW 5
#define NUM_TILES_PER_COL 5

typedef struct {
    char text[30];
    int row;
    int col;
    int is_marked;
} bingo_tile_t;

typedef struct {
    bingo_tile_t tiles[NUM_BINGO_TILES];
    int num_marked;
} bingo_card_t;

void init_bingo_tile(bingo_tile_t* tile) {
    tile->row = rand() % NUM_TILES_PER_ROW;
    tile->col = rand() % NUM_TILES_PER_COL;
    tile->is_marked = 0;
}

void init_bingo_card(bingo_card_t* card) {
    for (int i = 0; i < NUM_BINGO_TILES; i++) {
        init_bingo_tile(&card->tiles[i]);
    }
    card->num_marked = 0;
}

void mark_bingo_tile(bingo_tile_t* tile) {
    tile->is_marked = 1;
}

void mark_bingo_card(bingo_card_t* card) {
    for (int i = 0; i < NUM_BINGO_TILES; i++) {
        if (card->tiles[i].is_marked == 0) {
            mark_bingo_tile(&card->tiles[i]);
            card->num_marked++;
        }
    }
}

void print_bingo_card(bingo_card_t* card) {
    for (int i = 0; i < NUM_BINGO_TILES; i++) {
        printf("%s", card->tiles[i].text);
    }
}

void print_bingo_tile(bingo_tile_t* tile) {
    printf("%s", tile->text);
}

int main() {
    srand(time(NULL));

    bingo_card_t cards[NUM_CARDS];
    for (int i = 0; i < NUM_CARDS; i++) {
        init_bingo_card(&cards[i]);
    }

    for (int i = 0; i < NUM_CARDS; i++) {
        print_bingo_card(&cards[i]);
    }

    for (int i = 0; i < NUM_CARDS; i++) {
        mark_bingo_card(&cards[i]);
    }

    for (int i = 0; i < NUM_CARDS; i++) {
        print_bingo_card(&cards[i]);
    }

    return 0;
}