//Falcon-180B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_BAGS 100
#define NUM_CAROUSELS 4
#define MAX_BAGS_PER_CAROUSEL 25

typedef struct {
    int id;
    int destination;
    int carousel;
} Bag;

Bag bags[NUM_BAGS];
int num_bags = 0;

void generate_bags() {
    srand(time(NULL));

    for (int i = 0; i < NUM_BAGS; i++) {
        bags[i].id = i + 1;
        bags[i].destination = rand() % NUM_CAROUSELS + 1;
        bags[i].carousel = -1;
    }

    num_bags = NUM_BAGS;
}

void print_bags() {
    printf("Bags:\n");
    for (int i = 0; i < num_bags; i++) {
        printf("ID: %d, Destination: %d, Carousel: %d\n", bags[i].id, bags[i].destination, bags[i].carousel);
    }
}

void sort_bags(int (*compare)(const void *, const void *)) {
    qsort(bags, num_bags, sizeof(Bag), compare);
}

int compare_destinations(const void *a, const void *b) {
    return ((Bag*)a)->destination - ((Bag*)b)->destination;
}

int main() {
    generate_bags();
    print_bags();

    sort_bags(compare_destinations);
    print_bags();

    return 0;
}