//Falcon2-11B DATASET v1.0 Category: Socket programming ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netdb.h>

#define MAX_SIZE 1024

int main() {
    int sockfd, valread, valwrite;
    struct sockaddr_in serv_addr;
    char buffer[MAX_SIZE];

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("socket creation failed");
        return 1;
    }

    memset(&serv_addr, 0, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(5000);

    if (inet_pton(AF_INET, "127.0.0.1", &serv_addr.sin_addr) <= 0) {
        perror("Invalid address/ Address not supported");
        return 1;
    }

    valread = connect(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr));
    if (valread < 0) {
        perror("connect failed");
        return 1;
    }

    printf("Connected to server\n");

    valwrite = write(sockfd, "Hello, server!", 14);
    if (valwrite < 0) {
        perror("Write error");
        return 1;
    }

    valread = read(sockfd, buffer, MAX_SIZE);
    if (valread < 0) {
        perror("Read error");
        return 1;
    }

    printf("Server response: %s\n", buffer);

    close(sockfd);
    return 0;
}