//Falcon-180B DATASET v1.0 Category: System event logger ; Style: puzzling
#include<stdio.h>
#include<stdlib.h>
#include<time.h>
#include<string.h>

//Defining structure for event
typedef struct event
{
    int event_type;
    char *description;
    time_t timestamp;
}Event;

//Function to log events in a file
void log_event(FILE *log_file,int event_type,char *description)
{
    time_t current_time;
    char timestamp[20];

    //Get current time
    time(&current_time);

    //Format timestamp as string
    strftime(timestamp,20,"%Y-%m-%d %H:%M:%S",localtime(&current_time));

    //Create event structure
    Event event;
    event.event_type=event_type;
    event.description=description;
    event.timestamp=current_time;

    //Write event to log file
    fprintf(log_file,"%s - %s\n",timestamp,description);
}

//Main function
int main()
{
    FILE *log_file;
    char log_file_name[50]="event_log.txt";

    //Open log file for writing
    log_file=fopen(log_file_name,"w");

    //Check if log file was opened successfully
    if(log_file==NULL)
    {
        printf("Error opening log file.\n");
        exit(1);
    }

    //Log startup event
    log_event(log_file,1,"Program started.");

    //Simulate program execution
    for(int i=0;i<5;i++)
    {
        printf("Executing task %d...\n",i+1);
        fflush(stdout);
        sleep(1);
    }

    //Log shutdown event
    log_event(log_file,2,"Program ended.");

    //Close log file
    fclose(log_file);

    return 0;
}