//GEMINI-pro DATASET v1.0 Category: Fitness Tracker ; Style: scientific
#include <stdlib.h>
#include <stdio.h>
#include <time.h>

// Accelerometer data structure
typedef struct {
    double x;
    double y;
    double z;
} AccelerometerData;

// Fitness tracker data structure
typedef struct {
    int steps;
    double distance;
    double calories;
    AccelerometerData accelerometerData;
} FitnessTrackerData;

// Function to generate random accelerometer data
AccelerometerData generateRandomAccelerometerData() {
    AccelerometerData data;
    data.x = (double)rand() / RAND_MAX;
    data.y = (double)rand() / RAND_MAX;
    data.z = (double)rand() / RAND_MAX;
    return data;
}

// Function to generate random fitness tracker data
FitnessTrackerData generateRandomFitnessTrackerData() {
    FitnessTrackerData data;
    data.steps = rand() % 10000;
    data.distance = (double)rand() / RAND_MAX * 10000;
    data.calories = (double)rand() / RAND_MAX * 1000;
    data.accelerometerData = generateRandomAccelerometerData();
    return data;
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Generate random fitness tracker data
    FitnessTrackerData data = generateRandomFitnessTrackerData();

    // Print the fitness tracker data
    printf("Steps: %d\n", data.steps);
    printf("Distance: %.2f km\n", data.distance / 1000);
    printf("Calories: %.2f kcal\n", data.calories);
    printf("Accelerometer data:\n");
    printf("  X: %.2f g\n", data.accelerometerData.x * 9.81);
    printf("  Y: %.2f g\n", data.accelerometerData.y * 9.81);
    printf("  Z: %.2f g\n", data.accelerometerData.z * 9.81);

    return 0;
}