//Code Llama-13B DATASET v1.0 Category: Task Scheduler ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>

// Global variables
int task_count = 0;
int task_id = 0;

// Structure to hold task information
typedef struct {
  int id;
  char name[50];
  int duration;
  int priority;
} Task;

// Array to hold task list
Task task_list[100];

// Function to create a new task
void create_task(char* name, int duration, int priority) {
  Task task;
  task.id = task_id++;
  task.duration = duration;
  task.priority = priority;
  strcpy(task.name, name);
  task_list[task_count++] = task;
}

// Function to print the task list
void print_task_list() {
  for (int i = 0; i < task_count; i++) {
    printf("%d: %s (%d sec, %d priority)\n", task_list[i].id, task_list[i].name, task_list[i].duration, task_list[i].priority);
  }
}

// Function to execute a task
void execute_task(Task* task) {
  printf("Executing task %d: %s (%d sec, %d priority)\n", task->id, task->name, task->duration, task->priority);
  sleep(task->duration);
}

// Function to sort tasks by priority
void sort_tasks() {
  for (int i = 0; i < task_count - 1; i++) {
    for (int j = i + 1; j < task_count; j++) {
      if (task_list[i].priority > task_list[j].priority) {
        Task temp = task_list[i];
        task_list[i] = task_list[j];
        task_list[j] = temp;
      }
    }
  }
}

// Function to run the task scheduler
void run_task_scheduler() {
  sort_tasks();
  for (int i = 0; i < task_count; i++) {
    execute_task(&task_list[i]);
  }
}

int main() {
  create_task("Task 1", 5, 1);
  create_task("Task 2", 3, 2);
  create_task("Task 3", 2, 3);
  create_task("Task 4", 1, 4);
  create_task("Task 5", 3, 1);
  print_task_list();
  run_task_scheduler();
  return 0;
}