//GEMINI-pro DATASET v1.0 Category: Drone Remote Control ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <termios.h>
#include <string.h>

#define BAUDRATE B115200
#define DEVICE "/dev/ttyUSB0"

int main(int argc, char *argv[]) {
    int fd;
    struct termios options;

    // Open the serial port
    fd = open(DEVICE, O_RDWR | O_NOCTTY | O_NDELAY);
    if (fd == -1) {
        perror("open");
        return EXIT_FAILURE;
    }

    // Configure the serial port
    tcgetattr(fd, &options);
    options.c_cflag &= ~PARENB;  // Disable parity
    options.c_cflag &= ~CSTOPB;  // Set stop bits to 1
    options.c_cflag &= ~CSIZE;  // Set data bits to 8
    options.c_cflag |= CS8;
    options.c_cflag |= CREAD | CLOCAL;  // Enable receiver and ignore modem control lines
    options.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);  // Disable canonical mode, echo, and signal handling
    options.c_oflag &= ~OPOST;  // Disable output processing
    options.c_cc[VMIN] = 0;  // Set minimum number of characters to read to 0
    options.c_cc[VTIME] = 0;  // Set timeout to 0
    tcsetattr(fd, TCSANOW, &options);

    // Send a command to the drone
    const char *command = "takeoff";
    write(fd, command, strlen(command));

    // Read the response from the drone
    char response[256];
    int bytes_read = read(fd, response, sizeof(response));
    if (bytes_read > 0) {
        printf("Response from drone: %s\n", response);
    }

    // Close the serial port
    close(fd);

    return EXIT_SUCCESS;
}