//Falcon-180B DATASET v1.0 Category: Memory Game ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_CARDS 10
#define NUM_ROWS 3
#define NUM_COLS 2

int deck[NUM_CARDS];
int cards_left = NUM_CARDS;
int num_matches = 0;
int num_moves = 0;
int num_turns = 0;

void shuffle_deck() {
    for (int i = 0; i < NUM_CARDS; i++) {
        deck[i] = i + 1;
    }
    for (int i = 0; i < NUM_CARDS; i++) {
        int j = rand() % NUM_CARDS;
        int temp = deck[i];
        deck[i] = deck[j];
        deck[j] = temp;
    }
}

void deal_cards() {
    for (int i = 0; i < NUM_ROWS; i++) {
        for (int j = 0; j < NUM_COLS; j++) {
            int card = deck[cards_left - 1];
            deck[cards_left - 1] = 0;
            cards_left--;
            printf("%d ", card);
        }
        printf("\n");
    }
}

int check_match(int card1, int card2) {
    return card1 == card2;
}

void play_game() {
    srand(time(NULL));
    shuffle_deck();
    deal_cards();

    int player_card1 = 0;
    int player_card2 = 0;

    while (num_matches < NUM_CARDS / 2) {
        int card1 = deck[0];
        int card2 = deck[1];

        if (check_match(card1, card2)) {
            num_matches++;
            deck[0] = 0;
            deck[1] = 0;
            printf("Match found! ");
        } else {
            printf("No match. ");
            num_moves++;
            deck[0] = 0;
            deck[1] = 0;
        }

        if (cards_left == 0) {
            num_turns++;
            shuffle_deck();
            deal_cards();
        }
    }

    printf("Game over. You found %d matches in %d turns and %d moves. ", num_matches, num_turns, num_moves);
}

int main() {
    play_game();
    return 0;
}