//MISTRAL-7B DATASET v1.0 Category: Unit converter ; Style: optimized
#include <stdio.h>
#include <stdlib.h>

#define PI 3.14159265358979323846

typedef struct {
    float value;
    char unit;
} Unit;

Unit convert(Unit base, float factor, Unit to) {
    Unit result;

    result.value = base.value * factor;
    result.unit = to.unit;

    return result;
}

Unit feetToMeters(float feet) {
    Unit base = {feet, 'ft'};
    Unit meter = {1.0, 'm'};

    Unit result = convert(base, 0.3048, meter);

    return result;
}

Unit milesToKilometers(float miles) {
    Unit base = {miles, 'mi'};
    Unit kilometer = {1.60934, 'km'};

    Unit result = convert(base, 1.60934, kilometer);

    return result;
}

Unit poundsToKilograms(float pounds) {
    Unit base = {pounds, 'lbs'};
    Unit kilogram = {2.20462, 'kg'};

    Unit result = convert(base, 2.20462, kilogram);

    return result;
}

void printUnit(Unit unit) {
    printf("%.2f %c\n", unit.value, unit.unit);
}

int main() {
    float feet = 5.0;
    float miles = 10.5;
    float pounds = 150.3;

    Unit feetMeters = feetToMeters(feet);
    Unit milesKilometers = milesToKilometers(miles);
    Unit poundsKilograms = poundsToKilograms(pounds);

    printf("5 feet is equal to: ");
    printUnit(feetMeters);

    printf("\n10.5 miles is equal to: ");
    printUnit(milesKilometers);

    printf("\n150.3 pounds is equal to: ");
    printUnit(poundsKilograms);

    return 0;
}