//Code Llama-13B DATASET v1.0 Category: Building a POP3 Client ; Style: invasive
// POP3 Client example program in an invasive style

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <unistd.h>

#define POP3_PORT 110
#define BUFFER_SIZE 1024

int main(int argc, char *argv[]) {
    int sock, n;
    char buffer[BUFFER_SIZE];
    struct sockaddr_in server_addr;

    // create socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1) {
        perror("socket");
        exit(1);
    }

    // set up server address
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(POP3_PORT);
    server_addr.sin_addr.s_addr = inet_addr(argv[1]);

    // connect to server
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        perror("connect");
        exit(1);
    }

    // send the USER command
    if (send(sock, "USER\r\n", strlen("USER\r\n"), 0) == -1) {
        perror("send");
        exit(1);
    }

    // receive the response
    if ((n = recv(sock, buffer, BUFFER_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    // send the PASS command
    if (send(sock, "PASS\r\n", strlen("PASS\r\n"), 0) == -1) {
        perror("send");
        exit(1);
    }

    // receive the response
    if ((n = recv(sock, buffer, BUFFER_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    // send the STAT command
    if (send(sock, "STAT\r\n", strlen("STAT\r\n"), 0) == -1) {
        perror("send");
        exit(1);
    }

    // receive the response
    if ((n = recv(sock, buffer, BUFFER_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    // send the LIST command
    if (send(sock, "LIST\r\n", strlen("LIST\r\n"), 0) == -1) {
        perror("send");
        exit(1);
    }

    // receive the response
    if ((n = recv(sock, buffer, BUFFER_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    // send the RETR command
    if (send(sock, "RETR 1\r\n", strlen("RETR 1\r\n"), 0) == -1) {
        perror("send");
        exit(1);
    }

    // receive the response
    if ((n = recv(sock, buffer, BUFFER_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    // send the DELE command
    if (send(sock, "DELE 1\r\n", strlen("DELE 1\r\n"), 0) == -1) {
        perror("send");
        exit(1);
    }

    // receive the response
    if ((n = recv(sock, buffer, BUFFER_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    // send the RSET command
    if (send(sock, "RSET\r\n", strlen("RSET\r\n"), 0) == -1) {
        perror("send");
        exit(1);
    }

    // receive the response
    if ((n = recv(sock, buffer, BUFFER_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    // send the NOOP command
    if (send(sock, "NOOP\r\n", strlen("NOOP\r\n"), 0) == -1) {
        perror("send");
        exit(1);
    }

    // receive the response
    if ((n = recv(sock, buffer, BUFFER_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    // send the QUIT command
    if (send(sock, "QUIT\r\n", strlen("QUIT\r\n"), 0) == -1) {
        perror("send");
        exit(1);
    }

    // receive the response
    if ((n = recv(sock, buffer, BUFFER_SIZE, 0)) == -1) {
        perror("recv");
        exit(1);
    }

    // close the socket
    close(sock);

    return 0;
}