//Falcon-180B DATASET v1.0 Category: Fractal Generation ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>
#include <GL/gl.h>
#include <GL/glu.h>

// Function to draw fractal
void fractal(int x1, int y1, int x2, int y2, int depth) {
    if (depth == 0) {
        glBegin(GL_POINTS);
        glVertex2i(x1, y1);
        glEnd();
        return;
    }
    int deltaX = x2 - x1;
    int deltaY = y2 - y1;
    int newX1 = x1 + deltaX / 3;
    int newY1 = y1 + deltaY / 3;
    int newX2 = x2 - deltaX / 3;
    int newY2 = y2 - deltaY / 3;
    fractal(x1, y1, newX1, newY1, depth - 1);
    fractal(newX1, newY1, newX2, newY2, depth - 1);
    fractal(newX2, newY2, x2, y2, depth - 1);
}

// Function to initialize GLUT and GL
void init() {
    glClearColor(0.0, 0.0, 0.0, 0.0);
    gluOrtho2D(0.0, 800.0, 0.0, 600.0);
}

// Function to draw the fractal
void drawFractal() {
    glClear(GL_COLOR_BUFFER_BIT);
    glColor3f(1.0, 1.0, 1.0);
    fractal(0, 0, 800, 600, 4);
    glutSwapBuffers();
}

// Main function
int main(int argc, char **argv) {
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);
    glutInitWindowSize(800, 600);
    glutInitWindowPosition(0, 0);
    glutCreateWindow("Fractal");
    init();
    glutDisplayFunc(drawFractal);
    glutMainLoop();
    return 0;
}