//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <curl/curl.h>

size_t WriteCallback(void* contents, size_t size, size_t nmemb, void* userp) {
    size_t realsize = size * nmemb;
    char* data = (char*)malloc(realsize + 1);
    if (data == NULL) {
        return 0;
    }
    memcpy(data, contents, realsize);
    data[realsize] = '\0';
    *(char**)userp = data;
    return realsize;
}

int main(int argc, char* argv[]) {
    CURL* curl = curl_easy_init();
    if (curl == NULL) {
        fprintf(stderr, "curl_easy_init() failed\n");
        return 1;
    }

    char* url = "https://jsonplaceholder.typicode.com/todos/1";
    curl_easy_setopt(curl, CURLOPT_URL, url);

    struct curl_slist* headers = NULL;
    headers = curl_slist_append(headers, "Content-Type: application/json");
    curl_easy_setopt(curl, CURLOPT_HTTPHEADER, headers);

    char* data = "{\"title\": \"Buy groceries\"}";
    curl_easy_setopt(curl, CURLOPT_POSTFIELDS, data);

    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
    char* response = NULL;

    CURLcode res = curl_easy_perform(curl);
    if (res!= CURLE_OK) {
        fprintf(stderr, "curl_easy_perform() failed: %s\n",
                curl_easy_strerror(res));
        return 1;
    }

    curl_easy_cleanup(curl);
    curl_slist_free_all(headers);
    free(response);

    return 0;
}