//GEMINI-pro DATASET v1.0 Category: Database querying ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

int main() {
    sqlite3 *db;
    sqlite3_stmt *stmt;
    int rc;
    char *sql;

    // Open the database
    rc = sqlite3_open("test.db", &db);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "Error opening database: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    // Prepare the SQL statement to use prepared statements
    sql = "SELECT * FROM users WHERE username = ? AND password = ?;";
    rc = sqlite3_prepare_v2(db, sql, -1, &stmt, NULL);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "Error preparing statement: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    // Bind the parameters to the prepared statement
    rc = sqlite3_bind_text(stmt, 1, "username", -1, SQLITE_TRANSIENT);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "Error binding parameter 1: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    rc = sqlite3_bind_text(stmt, 2, "password", -1, SQLITE_TRANSIENT);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "Error binding parameter 2: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    // Execute the query
    rc = sqlite3_step(stmt);
    if (rc != SQLITE_ROW) {
        fprintf(stderr, "Error executing query: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    // Get the results
    int user_id = sqlite3_column_int(stmt, 0);
    const char *username = sqlite3_column_text(stmt, 1);
    const char *password = sqlite3_column_text(stmt, 2);

    // Print the results
    printf("User ID: %d\n", user_id);
    printf("Username: %s\n", username);
    printf("Password: %s\n", password);

    // Finalize the statement
    sqlite3_finalize(stmt);

    // Close the database
    sqlite3_close(db);

    return 0;
}