//Falcon-180B DATASET v1.0 Category: Tower of Hanoi Problem ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_DISKS 64

typedef struct {
    int num_disks;
    char from_rod;
    char to_rod;
    char aux_rod;
} Move;

void move_disk(int num_disks, char from_rod, char to_rod, char aux_rod) {
    printf("Move disk %d from rod %c to rod %c using rod %c\n", num_disks, from_rod, to_rod, aux_rod);
}

void print_rods(char a, char b, char c) {
    printf("Rod A: ");
    for (int i = MAX_DISKS - 1; i >= 0; i--) {
        if (i < a) {
            printf("-");
        } else if (i == a) {
            printf("*");
        } else {
            printf(" ");
        }
    }
    printf("\n");

    printf("Rod B: ");
    for (int i = MAX_DISKS - 1; i >= 0; i--) {
        if (i < b) {
            printf("-");
        } else if (i == b) {
            printf("*");
        } else {
            printf(" ");
        }
    }
    printf("\n");

    printf("Rod C: ");
    for (int i = MAX_DISKS - 1; i >= 0; i--) {
        if (i < c) {
            printf("-");
        } else if (i == c) {
            printf("*");
        } else {
            printf(" ");
        }
    }
    printf("\n");
}

int main() {
    srand(time(NULL));
    int num_disks = rand() % (MAX_DISKS - 1) + 1;
    int a = 0, b = 0, c = 0;
    for (int i = num_disks; i > 0; i--) {
        Move move = {i, 'A', 'C', 'B'};
        move_disk(move.num_disks, move.from_rod, move.to_rod, move.aux_rod);
        if (i <= MAX_DISKS - 2) {
            a++;
        }
    }
    print_rods(a, b, c);
    return 0;
}