//MISTRAL-7B DATASET v1.0 Category: Word Frequency Counter ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

#define WORD_LENGTH 50
#define WORD_COUNT 1000

typedef struct Word {
    char words[WORD_LENGTH];
    int count;
} Word;

bool is_alpha(char c) {
    return (isalpha(c) || isspace(c));
}

void split_word(char *line, Word *words, int *num_words) {
    int i = 0, j = 0, word_index = 0;
    char word[WORD_LENGTH];

    while (i < strlen(line)) {
        if (is_alpha(line[i])) {
            word[j] = tolower(line[i]);
            j++;
        } else if (j > 0) {
            word[j] = '\0';
            if (strcmp(words[word_index].words, word) == 0) {
                words[word_index].count++;
            } else {
                if (word_index < WORD_COUNT - 1) {
                    word_index++;
                    for (int k = 0; k < WORD_LENGTH; k++) {
                        words[word_index].words[k] = '\0';
                    }
                } else {
                    printf("Error: Reached maximum word count.\n");
                    exit(1);
                }
                strcpy(words[word_index].words, word);
                words[word_index].count = 1;
            }
            j = 0;
            i++;
        } else {
            i++;
        }
    }

    *num_words = word_index + 1;
}

int main() {
    FILE *fp;
    char line[1024];
    Word words[WORD_COUNT];
    int num_words;

    if ((fp = fopen("words.txt", "r")) == NULL) {
        printf("Error: Could not open file 'words.txt'\n");
        exit(1);
    }

    while (fgets(line, sizeof(line), fp) != NULL) {
        split_word(line, words, &num_words);
    }

    fclose(fp);

    printf("Word frequencies:\n");
    for (int i = 0; i < num_words; i++) {
        printf("%s: %d\n", words[i].words, words[i].count);
    }

    return 0;
}