//GPT-4o-mini DATASET v1.0 Category: Packet Capturer with pcap library ; Style: random
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <netinet/ip.h>

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    const struct ip *ip_header;
    ip_header = (struct ip*)(packet + 14); // Skip Ethernet header

    // Print IP address and packet length
    printf("Captured a packet from: %s\n", inet_ntoa(ip_header->ip_src));
    printf("To: %s\n", inet_ntoa(ip_header->ip_dst));
    printf("Length: %d bytes\n\n", header->len);
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        return EXIT_FAILURE;
    }

    char *dev = argv[1];
    char errbuf[PCAP_ERRBUF_SIZE];

    // Open the device for packet capturing in promiscuous mode
    pcap_t *handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return EXIT_FAILURE;
    }

    // Set a filter to capture only IPv4 packets
    struct bpf_program fp;
    char filter_exp[] = "ip";
    if (pcap_compile(handle, &fp, filter_exp, 0, PCAP_NETMASK_UNKNOWN) == -1) {
        fprintf(stderr, "Could not parse filter %s: %s\n", filter_exp, pcap_geterr(handle));
        return EXIT_FAILURE;
    }
    if (pcap_setfilter(handle, &fp) == -1) {
        fprintf(stderr, "Could not install filter %s: %s\n", filter_exp, pcap_geterr(handle));
        return EXIT_FAILURE;
    }

    // Start packet capture loop
    printf("Starting packet capture on %s...\n", dev);
    pcap_loop(handle, 10, packet_handler, NULL); // Capture 10 packets

    // Clean up
    pcap_freecode(&fp);
    pcap_close(handle);
    printf("Packet capture ended.\n");

    return EXIT_SUCCESS;
}