//Falcon-180B DATASET v1.0 Category: Database querying ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

#define MAX_SQL_LENGTH 1000

typedef struct {
    char *zErrMsg;
    int rc;
} ErrorHandler;

static int callback(void *data, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i]? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

static char *errMsg = 0;

static void error_callback(void *data, int argc, char **argv, char **azColName) {
    if (errMsg) {
        free(errMsg);
    }
    errMsg = strdup(argv[0]);
}

int main(int argc, char **argv) {
    sqlite3 *db;
    char *zErrMsg = 0;
    int rc;

    if (argc < 2) {
        fprintf(stderr, "Usage: %s DATABASE\n", argv[0]);
        return 1;
    }

    rc = sqlite3_open(argv[1], &db);

    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    char sql[MAX_SQL_LENGTH];
    snprintf(sql, MAX_SQL_LENGTH, "SELECT * FROM surrealist_artists;");

    char *errMsg = 0;
    rc = sqlite3_exec(db, sql, callback, 0, &errMsg);

    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        fprintf(stdout, "Operation done successfully\n");
    }

    sqlite3_close(db);

    return 0;
}