//Gemma-7B DATASET v1.0 Category: Simple Web Server ; Style: calm
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>

#define PORT 8080

int main()
{
    int sockfd, newsockfd, clilen;
    struct sockaddr_in serv_addr, cli_addr;

    // Socket setup
    sockfd = socket(AF_INET, SOCK_STREAM, htons(PORT));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    // Bind the socket to a port
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(PORT);
    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0)
    {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for clients
    listen(sockfd, &clilen);

    // Accept a client connection
    newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, &clilen);
    if (newsockfd < 0)
    {
        perror("Error accepting client connection");
        exit(1);
    }

    // Client communication
    char buffer[1024];
    int nread = read(newsockfd, buffer, 1024);
    if (nread < 0)
    {
        perror("Error reading from client");
        exit(1);
    }

    // Print client message
    printf("Client: %s\n", buffer);

    // Send a response
    char response[20] = "Hello, client!";
    write(newsockfd, response, sizeof(response));

    // Close the connection
    close(newsockfd);

    return 0;
}