//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: calm
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

#define MAX_PASSWORD_LENGTH 32

bool is_valid_password(char *password) {
    int length = strlen(password);

    if (length < 8 || length > MAX_PASSWORD_LENGTH) {
        printf("Password must be between 8 and %d characters long.\n", MAX_PASSWORD_LENGTH);
        return false;
    }

    int num_uppercase = 0;
    int num_lowercase = 0;
    int num_numbers = 0;
    int num_special_chars = 0;

    for (int i = 0; i < length; i++) {
        char c = tolower(password[i]);

        if (isalpha(c)) {
            if (isupper(c)) {
                num_uppercase++;
            } else {
                num_lowercase++;
            }
        } else if (isdigit(c)) {
            num_numbers++;
        } else if (c == '!' || c == '@' || c == '#' || c == '$' || c == '%' || c == '^' || c == '&' || c == '*') {
            num_special_chars++;
        }
    }

    if (num_uppercase == 0 || num_lowercase == 0 || num_numbers == 0 || num_special_chars == 0) {
        printf("Password must contain at least one uppercase letter, one lowercase letter, one number, and one special character.\n");
        return false;
    }

    return true;
}

int main() {
    char password[MAX_PASSWORD_LENGTH];

    printf("Enter your password: ");
    fgets(password, MAX_PASSWORD_LENGTH, stdin);

    if (is_valid_password(password)) {
        printf("Password is strong.\n");
    } else {
        printf("Password is weak.\n");
    }

    return 0;
}