//GPT-4o-mini DATASET v1.0 Category: Password Strength Checker ; Style: future-proof
#include <stdio.h>
#include <string.h>
#include <stdbool.h>
#include <ctype.h>

#define MIN_PASSWORD_LENGTH 8
#define MAX_PASSWORD_LENGTH 20

// Function declarations
bool is_valid_length(const char *password);
bool has_uppercase(const char *password);
bool has_lowercase(const char *password);
bool has_number(const char *password);
bool has_special_char(const char *password);
int check_password_strength(const char *password);
void print_strength_message(int strength);

int main() {
    char password[MAX_PASSWORD_LENGTH + 1];

    printf("Enter your password (max %d characters): ", MAX_PASSWORD_LENGTH);
    fgets(password, sizeof(password), stdin);
    
    // Remove newline character if it exists
    size_t len = strlen(password);
    if(len > 0 && password[len - 1] == '\n') {
        password[len - 1] = '\0';
    }

    // Check and print password strength
    int strength = check_password_strength(password);
    print_strength_message(strength);

    return 0;
}

// Check if password length is valid
bool is_valid_length(const char *password) {
    int len = strlen(password);
    return len >= MIN_PASSWORD_LENGTH && len <= MAX_PASSWORD_LENGTH;
}

// Check for uppercase letters
bool has_uppercase(const char *password) {
    while(*password) {
        if (isupper(*password)) {
            return true;
        }
        password++;
    }
    return false;
}

// Check for lowercase letters
bool has_lowercase(const char *password) {
    while(*password) {
        if (islower(*password)) {
            return true;
        }
        password++;
    }
    return false;
}

// Check for numbers
bool has_number(const char *password) {
    while(*password) {
        if (isdigit(*password)) {
            return true;
        }
        password++;
    }
    return false;
}

// Check for special characters
bool has_special_char(const char *password) {
    const char *special_chars = "!@#$%^&*()-_=+[]{};:'\"\\|,.<>?/`~";
    while(*password) {
        if (strchr(special_chars, *password)) {
            return true;
        }
        password++;
    }
    return false;
}

// Function to evaluate password strength
int check_password_strength(const char *password) {
    if (!is_valid_length(password)) {
        return 0;
    }
    
    int score = 0;
    if (has_uppercase(password)) score++;
    if (has_lowercase(password)) score++;
    if (has_number(password)) score++;
    if (has_special_char(password)) score++;

    return score;
}

// Print strength message based on score
void print_strength_message(int strength) {
    switch(strength) {
        case 0:
            printf("Password is too weak. Please try again.\n");
            break;
        case 1:
            printf("Password strength: Weak. Include uppercase, numbers, and special characters.\n");
            break;
        case 2:
            printf("Password strength: Fair. Consider adding more variety.\n");
            break;
        case 3:
            printf("Password strength: Good. It’s a reasonable password, but can be improved further.\n");
            break;
        case 4:
            printf("Password strength: Strong! Good job on creating a secure password.\n");
            break;
        default:
            printf("An unexpected error occurred in password evaluation.\n");
            break;
    }
}