//GEMINI-pro DATASET v1.0 Category: Elevator Simulation ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FLOORS 10
#define MAX_ELEVATORS 4

typedef struct Elevator {
    int current_floor;
    int destination_floor;
    int direction; // 1 for up, -1 for down
    int num_passengers;
    int passenger_ids[MAX_FLOORS];
} Elevator;

typedef struct Floor {
    int num_passengers;
    int passenger_ids[MAX_ELEVATORS];
} Floor;

Elevator elevators[MAX_ELEVATORS];
Floor floors[MAX_FLOORS];

void initialize() {
    for (int i = 0; i < MAX_FLOORS; i++) {
        floors[i].num_passengers = 0;
        floors[i].passenger_ids[0] = -1;
        floors[i].passenger_ids[1] = -1;
        floors[i].passenger_ids[2] = -1;
        floors[i].passenger_ids[3] = -1;
    }

    for (int i = 0; i < MAX_ELEVATORS; i++) {
        elevators[i].current_floor = 0;
        elevators[i].destination_floor = -1;
        elevators[i].direction = 1;
        elevators[i].num_passengers = 0;
        elevators[i].passenger_ids[0] = -1;
        elevators[i].passenger_ids[1] = -1;
        elevators[i].passenger_ids[2] = -1;
        elevators[i].passenger_ids[3] = -1;
    }
}

void request_elevator(int floor) {
    floors[floor].num_passengers++;
    floors[floor].passenger_ids[0] = floor;
}

void assign_elevator(int floor) {
    int elevator_id = -1;
    int min_distance = MAX_FLOORS;
    for (int i = 0; i < MAX_ELEVATORS; i++) {
        int distance = abs(elevators[i].current_floor - floor);
        if (distance < min_distance) {
            min_distance = distance;
            elevator_id = i;
        }
    }

    elevators[elevator_id].destination_floor = floor;
    floors[floor].passenger_ids[elevator_id] = -1;
}

void move_elevators() {
    for (int i = 0; i < MAX_ELEVATORS; i++) {
        if (elevators[i].current_floor == elevators[i].destination_floor) {
            // Unload passengers
            for (int j = 0; j < elevators[i].num_passengers; j++) {
                int passenger_id = elevators[i].passenger_ids[j];
                floors[passenger_id].num_passengers--;
            }

            elevators[i].num_passengers = 0;
            elevators[i].destination_floor = -1;
            assign_elevator(floors[elevators[i].current_floor].passenger_ids[0]);
        } else {
            // Move elevator
            elevators[i].current_floor += elevators[i].direction;
        }
    }
}

void print_status() {
    printf("\nElevator Status:\n");
    for (int i = 0; i < MAX_ELEVATORS; i++) {
        printf("Elevator %d: current floor %d, destination floor %d, direction %d, passengers:\n",
            i, elevators[i].current_floor, elevators[i].destination_floor, elevators[i].direction);
        for (int j = 0; j < elevators[i].num_passengers; j++) {
            printf("\t%d\n", elevators[i].passenger_ids[j]);
        }
    }

    printf("\nFloor Status:\n");
    for (int i = 0; i < MAX_FLOORS; i++) {
        printf("Floor %d: passengers waiting:\n", i);
        for (int j = 0; j < floors[i].num_passengers; j++) {
            printf("\t%d\n", floors[i].passenger_ids[j]);
        }
    }
}

int main() {
    initialize();

    // Request elevator from different floors
    request_elevator(3);
    request_elevator(7);
    request_elevator(1);

    // Assign elevators to floors
    assign_elevator(3);
    assign_elevator(7);
    assign_elevator(1);

    // Move elevators
    move_elevators();

    // Print elevator and floor status
    print_status();

    return 0;
}