//Falcon-180B DATASET v1.0 Category: Bucket Sort Implementation ; Style: systematic
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 100

void bucketSort(int arr[], int n) {
    int i, j, min, max, range, bucket[MAX_SIZE] = {0};

    // Find minimum and maximum values in array
    min = arr[0];
    max = arr[0];
    for (i = 1; i < n; i++) {
        if (arr[i] < min) {
            min = arr[i];
        }
        if (arr[i] > max) {
            max = arr[i];
        }
    }

    // Calculate range of values in array
    range = max - min + 1;

    // Create empty buckets
    for (i = 0; i < range; i++) {
        bucket[i] = 0;
    }

    // Place elements in appropriate buckets
    for (i = 0; i < n; i++) {
        j = arr[i] - min;
        bucket[j]++;
    }

    // Concatenate buckets back into array
    i = 0;
    for (j = 0; j < range; j++) {
        while (bucket[j] > 0) {
            arr[i++] = min + j;
            bucket[j]--;
        }
    }
}

int main() {
    int arr[] = {7, 2, 1, 3, 0, 6, 8, 5, 4};
    int n = sizeof(arr) / sizeof(arr[0]);

    printf("Before sorting:\n");
    for (int i = 0; i < n; i++) {
        printf("%d ", arr[i]);
    }

    bucketSort(arr, n);

    printf("\nAfter sorting:\n");
    for (int i = 0; i < n; i++) {
        printf("%d ", arr[i]);
    }

    return 0;
}