//Falcon-180B DATASET v1.0 Category: Text Summarizer ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SENTENCE_LENGTH 1000
#define MAX_SENTENCES 1000
#define MIN_SENTENCE_LENGTH 10

typedef struct {
    char sentence[MAX_SENTENCE_LENGTH];
    int length;
} Sentence;

Sentence sentences[MAX_SENTENCES];
int num_sentences = 0;

void add_sentence(char* sentence) {
    if (num_sentences >= MAX_SENTENCES) {
        printf("Error: Too many sentences.\n");
        return;
    }

    int length = strlen(sentence);
    if (length < MIN_SENTENCE_LENGTH) {
        printf("Error: Sentence is too short.\n");
        return;
    }

    strcpy(sentences[num_sentences].sentence, sentence);
    sentences[num_sentences].length = length;

    num_sentences++;
}

void print_sentences() {
    for (int i = 0; i < num_sentences; i++) {
        printf("%s (%d words)\n", sentences[i].sentence, sentences[i].length);
    }
}

void summarize_sentences() {
    int total_words = 0;
    for (int i = 0; i < num_sentences; i++) {
        total_words += sentences[i].length;
    }

    int max_sentence_length = 0;
    for (int i = 0; i < num_sentences; i++) {
        if (sentences[i].length > max_sentence_length) {
            max_sentence_length = sentences[i].length;
        }
    }

    int summary_length = total_words / num_sentences;
    if (summary_length > max_sentence_length) {
        summary_length = max_sentence_length;
    }

    char summary[MAX_SENTENCE_LENGTH];
    total_words = 0;
    for (int i = 0; i < num_sentences; i++) {
        int words_to_copy = (sentences[i].length * summary_length) / max_sentence_length;
        strncpy(summary, sentences[i].sentence, words_to_copy);
        summary[words_to_copy] = '\0';
        total_words += words_to_copy;

        if (total_words >= summary_length) {
            break;
        }
    }

    printf("Summary:\n%s\n", summary);
}

int main() {
    add_sentence("The quick brown fox jumps over the lazy dog.");
    add_sentence("The lazy dog is not amused.");
    add_sentence("But the quick brown fox doesn't care.");

    print_sentences();

    summarize_sentences();

    return 0;
}