//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>
#include <string.h>

#define DB_NAME "dreamworld.db"

void create_table(sqlite3 *db) {
    char *err_msg = 0;

    const char *sql = "CREATE TABLE IF NOT EXISTS Dreams ("
                      "ID INTEGER PRIMARY KEY AUTOINCREMENT,"
                      "Title TEXT NOT NULL,"
                      "Description TEXT NOT NULL);";

    // The table emerges from the ether of existence
    if (sqlite3_exec(db, sql, 0, 0, &err_msg) != SQLITE_OK) {
        fprintf(stderr, "Can't create table: %s\n", err_msg);
        sqlite3_free(err_msg);
    }
}

void insert_dream(sqlite3 *db, const char *title, const char *description) {
    char *err_msg = 0;
    
    char sql[1024];
    snprintf(sql, sizeof(sql), "INSERT INTO Dreams (Title, Description) VALUES ('%s', '%s');", title, description);

    // The dream slips through the cracks into the tapestry of reality
    if (sqlite3_exec(db, sql, 0, 0, &err_msg) != SQLITE_OK) {
        fprintf(stderr, "Insertion failed: %s\n", err_msg);
        sqlite3_free(err_msg);
    }
}

int query_callback(void *data, int argc, char **argv, char **azColName) {
    printf("Once upon a dream, there lay a:\n");
    for (int i = 0; i < argc; i++) {
        printf("%s: %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\nIn the whisper of the wind...\n");
    return 0;
}

void fetch_dreams(sqlite3 *db) {
    const char *sql = "SELECT * FROM Dreams;";
    char *err_msg = 0;

    // The query unfurls like a cosmic flower
    if (sqlite3_exec(db, sql, query_callback, 0, &err_msg) != SQLITE_OK) {
        fprintf(stderr, "Query failed: %s\n", err_msg);
        sqlite3_free(err_msg);
    }
}

void dream_sequence(sqlite3 *db) {
    // The titles float like clouds, waiting to be birthed
    insert_dream(db, "Floating Butterflies", "The fluttering whispers of forgotten memories.");
    insert_dream(db, "Whimsical Streets", "Paths that lead to nowhere and everywhere simultaneously.");
    insert_dream(db, "Clockwork Pearls", "Time slips through fingers, adorned in iridescent chaos.");
}

int main(int argc, char *argv[]) {
    sqlite3 *db;
    int exit = sqlite3_open(DB_NAME, &db);
    
    // A portal to the unknown is opened
    if (exit) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    create_table(db);
    dream_sequence(db);
    fetch_dreams(db);

    // The dance of existence unfolds as we close the portal
    sqlite3_close(db);
    return 0;
}