//GEMINI-pro DATASET v1.0 Category: Client Server Application ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define PORT 9000
#define MAX_BUFFER_SIZE 1024

int main() {
  int server_socket_fd, client_socket_fd, client_addr_len;
  struct sockaddr_in server_addr, client_addr;
  char buffer[MAX_BUFFER_SIZE];

  // Create a server socket
  server_socket_fd = socket(AF_INET, SOCK_STREAM, 0);
  if (server_socket_fd < 0) {
    perror("socket() failed");
    exit(EXIT_FAILURE);
  }

  // Set up the server address
  memset(&server_addr, 0, sizeof(server_addr));
  server_addr.sin_family = AF_INET;
  server_addr.sin_addr.s_addr = INADDR_ANY;
  server_addr.sin_port = htons(PORT);

  // Bind the server socket to the address
  if (bind(server_socket_fd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("bind() failed");
    exit(EXIT_FAILURE);
  }

  // Listen for incoming connections
  if (listen(server_socket_fd, 5) < 0) {
    perror("listen() failed");
    exit(EXIT_FAILURE);
  }

  // Accept an incoming connection
  client_addr_len = sizeof(client_addr);
  client_socket_fd = accept(server_socket_fd, (struct sockaddr *)&client_addr, &client_addr_len);
  if (client_socket_fd < 0) {
    perror("accept() failed");
    exit(EXIT_FAILURE);
  }

  // Receive data from the client
  memset(buffer, 0, MAX_BUFFER_SIZE);
  if (recv(client_socket_fd, buffer, MAX_BUFFER_SIZE, 0) < 0) {
    perror("recv() failed");
    exit(EXIT_FAILURE);
  }

  // Process the data received from the client
  printf("Received data from client: %s\n", buffer);

  // Send data back to the client
  memset(buffer, 0, MAX_BUFFER_SIZE);
  strcpy(buffer, "Hello from server");
  if (send(client_socket_fd, buffer, strlen(buffer), 0) < 0) {
    perror("send() failed");
    exit(EXIT_FAILURE);
  }

  // Close the client socket
  close(client_socket_fd);

  // Close the server socket
  close(server_socket_fd);

  return 0;
}